function startBattle(id, background, party, music)
{
	// Load battle from file
	battle = new Battle();
	battle.load(id);
	battle.background = LoadImage("background_" + background + ".png");
	if (party == undefined)
	{
		battle.party = system.party;
	}
	else
		battle.party = party;
	battle.getList();
	if (music == undefined)
	{
		system.music = LoadSound("battle.ogg"); // Load battle music
		system.music.play(true);
	}
	else if (music != false)
	{
		system.music = LoadSound(music); // Load custom music
		system.music.play(true);
	}
	system.currentBattle = battle;
	log.write("Battle: Intro effect");
	battleEffect(battle);
	log.write("Battle: Start");
	battle.start();
	log.write("Battle: Main loop");
	battle.engine();
	if (music != false)
	{
		system.music.stop();
	}
	system.currentBattle = undefined;
}

function Battle()
{
	this.delay = new Array();
	this.enemy = new Array();
	this.party = new Array();
	this.finished = false;
	this.message = new Array();
	this.menu = new Array();
	this.messageTime = 0;
	this.delayTime = 0;
	this.currentCharacter = false;
	this.infoStyle = "Normal";
}

Battle.prototype.load = function(id)
{
	var file = OpenFile("battle.dat");
	var heading = "ID" + id + ":";
	var eNum = file.read(heading+"EnemyNum", 0);
	this.enemy = new Array();
	for (var i = 0; i < eNum; i ++)
	{
		this.addEnemy(file.read(heading+"Enemy"+ i + ":Name", ""), file.read(heading + "Enemy" + i + ":X", 0), file.read(heading + "Enemy" + i + ":Y", 0));
	}
	var idelay = file.read(heading + "Delay", 0);
	if (idelay > 0)
	{
		this.addDelay(idelay);
	}
	var imessages = file.read(heading + "Messages", 0);
	if (imessages > 0)
	{
		for (var i = 1; i <= imessages; i ++)
		{
			this.addMessage(file.read(heading + "Message" + i + ":Text", ""), file.read(heading + "Message" + i + ":Speaker", ""));
		}
	}
}

Battle.prototype.addEnemy = function(name, x, y)
{
	var enemy = new Enemy();
	enemy.load(name);
	enemy.x = x;
	enemy.y = y;
	this.enemy[this.enemy.length] = enemy;
}

Battle.prototype.start = function()
{
	this.messageTime = GetTime();
	this.delayTime = GetTime();
	this.lastUpdate = GetTime();
}

Battle.prototype.update = function()
{
	// Check to see if someone isn't dead when they should be
	// Check characters
	for (var i = 0; i < this.enemy.length; i ++)
	{
		if (this.enemy[i].hp == 0)
		{
			if (this.enemy[i].sprite.color.alpha == 0)
			{
				this.enemy = arrayRemove(i, this.enemy);
				this.getList();
			}
			else
			{
				this.enemy[i].sprite.color.alpha -= 5;
				this.enemy[i].sprite.scale += .02;
				this.enemy[i].sprite.degree += 2;
			}
		}
	}
	// Check to see if someone won the battle
	if (this.enemy.length == 0)
	{
		this.finished = true;
	}
	// Update damage
	for (var i = 0; i < this.list.length; i ++)
	{
		if (this.list[i].damage != undefined)
		{
			if (this.list[i].damage.counter == 54)
			{
				this.list[i].damage = undefined;
			}
			else
			{
				this.list[i].damage.update();
			}
		}
	}
	// Update sprites
	// Update effect
}

Battle.prototype.control = function()
{
	if (IsPress())
	{
		if (IsKeyPressed(KEY_SHIFT))
		{
			if (IsKeyPressed(KEY_ESCAPE))
			{
				this.finished = true;
			}
			else if (IsKeyPressed(KEY_UP))
			{
				setInfoStyle("HP");
			}
			else if (IsKeyPressed(KEY_RIGHT))
			{
				setInfoStyle("MP");
			}
			else if (IsKeyPressed(KEY_LEFT))
			{
				setInfoStyle("Status");
			}
			else if (IsKeyPressed(KEY_DOWN))
			{
				setInfoStyle("Normal");
			}
		}
	}
	if (this.menu.length > 0)
	{
		var selection = this.menu[this.menu.length - 1].control(18, 180, 4);
		if (selection != undefined)
		{
			log.write("Sort");
			this.menu[this.menu.length - 1].sortFunction(selection);
		}
	}
}

// Main battle loop
Battle.prototype.engine = function()
{
	while (!this.finished)
	{
		if (this.currentCharacter == false && this.delay.length == 0 && this.message.length == 0 && this.ready())
		{
			this.currentCharacter = this.figurate();
			this.currentCharacter.turn();
		}
		else
		{
			this.draw();
			FlipScreen();
			this.update();
			if (this.delay.length > 0)
			{
				if (GetTime() >= this.delay[0].time + this.delayTime)
				{
					execute(this.delay[0].script);
					this.delay.shift();
					if (this.delay.length > 0)
					{
						this.delayTime = GetTime();
					}
				}
			}
			if (this.message.length > 0)
			{
				if (GetTime() >= system.battleMessageSpeed + this.messageTime)
				{
					this.message.shift();
					if (this.message.length > 0)
					{
						this.messageTime = GetTime();
					}
				}
			}
		}
		this.control();
	}
}

Battle.prototype.ready = function()
{
	for (var i = 0; i < this.list.length; i ++)
	{
		if (this.list[i].damage != undefined)
		{
			return false;
		}
		else if (this.list[i].sprite.color < 255)
		{
			return false;
		}
	}
	return true;
}

Battle.prototype.figurate = function()
{
	var person = undefined;
	var i = 0;
	while (person == undefined)
	{
		this.list[i].ct += getCharge(this.list[i]);
		if (this.list[i].ct >= 1000)
		{
			person = this.list[i];
			this.list[i].ct -= 1000;
		}
		i ++;
		if (i >= this.list.length)
		{
			i = 0;
		}
	}
	return person;
}

// Sets a delay in the battles
Battle.prototype.addDelay = function(time, script)
{
	var delay = new Object();
	delay.time = time;
	delay.script = script;
	this.delay[this.delay.length] = delay;
	this.delayTime = GetTime();
}

// Sets a message in battle
Battle.prototype.addMessage = function(text, speaker, icon)
{
	var message = new Object();
	message.text = text;
	message.speaker = speaker;
	if (icon != undefined && icon != "")
	{
		message.icon = images.icons[icon];
	}
	this.message[this.message.length] = message;
	this.messageTime = GetTime();
}

Battle.prototype.addMenu = function(menu, sortFunction, displayMenus)
{
	var currentMenu = new Object();
	currentMenu = menu;
	currentMenu.sortFunction = sortFunction;
	if (displayMenus == undefined)
	{
		currentMenu.displayMenus = false;
	}
	else
		currentMenu.displayMenus = displayMenus;
	this.menu[this.menu.length] = currentMenu;
}

Battle.prototype.getList = function()
{
	var list = new Array();
	for (var i = 0; i < this.party.length; i ++)
	{
		list[list.length] = this.party[i];
	}
	for (var i = 0; i < this.enemy.length; i ++)
	{
		list[list.length] = this.enemy[i];
	}
	this.list = list;
}

// Increase charge
function getCharge(person)
{
	var incr = person.agility;
	incr = incr * (random(224, 255) / 256);
	if (person.status["haste"])
	{
		incr *= 1.5;
	}
	else if (person.status["slow"])
	{
		incr *= .5;
	}
	else if (person.status["stop"])
	{
		incr = 0;
	}
	return Math.floor(incr);
}

// Sets display type of character info. "Normal", "Full", "HP", "MP", and "Status" are the available styles.
function setInfoStyle(style)
{
	system.currentBattle.infoStyle = style;
}

// Closes current menu
function closeMenu()
{
	system.currentBattle.menu.pop();
}

EvaluateScript("battle-draw.js");
EvaluateScript("battle-effect.js");
EvaluateScript("battle-figure.js");